/*
 * Decompiled with CFR 0.152.
 */
package Code;

import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class Designer {
    private static byte[] dat_textFont;
    private static int[] pal_textFont;
    public static final String charIndex = "/0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!\"#$%&'()*+,-.:;<=>?@[\\]^_`{|}~\u0309\u00b4\u02c7\u0110\u0111\u00e0\u00e1\u1ea3\u00e3\u1ea1\u0103\u1eb1\u1eaf\u1eb3\u1eb5\u1eb7\u00e2\u1ea7\u1ea5\u1ea9\u1eab\u1ead\u00e8\u00e9\u1ebb\u1ebd\u1eb9\u00ea\u1ec1\u1ebf\u1ec3\u1ec5\u1ec7\u00ec\u00ed\u1ec9\u0129\u1ecb\u00f2\u00f3\u1ecf\u00f5\u1ecd\u00f4\u1ed3\u1ed1\u1ed5\u1ed7\u1ed9\u01a1\u1edd\u1edb\u1edf\u1ee1\u1ee3\u00f9\u00fa\u1ee7\u0169\u1ee5\u01b0\u1eeb\u1ee9\u1eed\u1eef\u1ef1\u1ef3\u00fd\u1ef7\u1ef9\u1ef5\u00c0\u00c1\u1ea2\u00c3\u1ea0\u0102\u1eb0\u1eae\u1eb2\u1eb4\u1eb6\u00c2\u1ea6\u1ea4\u1ea8\u1eaa\u1eac\u00c8\u00c9\u1eba\u1ebc\u1eb8\u00ca\u1ec0\u1ebe\u1ec2\u1ec4\u1ec6\u00cc\u00cd\u1ec8\u0128\u1eca\u00d2\u00d3\u1ece\u00d5\u1ecc\u00d4\u1ed2\u1ed0\u1ed4\u1ed6\u1ed8\u01a0\u1edc\u1eda\u1ede\u1ee0\u1ee2\u00d9\u00da\u1ee6\u0168\u1ee4\u01af\u1eea\u1ee8\u1eec\u1eee\u1ef0\u1ef2\u00dd\u1ef6\u1ef8\u1ef4";
    private static byte[] textCharWidth;
    public static byte space;
    public static byte charTotalHeight;
    public static final byte MARGIN_LEFT = 0;
    public static final byte MARGIN_CENTER = 1;
    public static final byte MARGIN_RIGHT = 2;
    public static int[] rgb;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_MIRROR_ROT180 = 1;
    public static final byte TRANS_MIRROR = 2;
    public static final byte TRANS_ROT180 = 3;
    public static final byte TRANS_MIRROR_ROT270 = 4;
    public static final byte TRANS_ROT90 = 5;
    public static final byte TRANS_ROT270 = 6;
    public static final byte TRANS_MIRROR_ROT90 = 7;
    static /* synthetic */ Class class$java$io$InputStream;

    public static int toInt(byte[] b, int offset, int length) {
        int num = 0;
        int j = offset + length;
        for (int i = offset; i < j; ++i) {
            num = b[i] < 0 ? (num << 8) + 256 + b[i] : (num << 8) + b[i];
        }
        return num;
    }

    private static int[] readPal(InputStream is) {
        byte[] temp = new byte[4];
        int[] pal = null;
        try {
            is.read(temp, 0, 2);
            pal = new int[Designer.toInt(temp, 0, 2)];
            for (int i = 0; i < pal.length; ++i) {
                is.read(temp);
                pal[i] = Designer.toInt(temp, 0, 4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pal;
    }

    private static byte[] readData(InputStream is) {
        byte[] temp = new byte[4];
        byte[] data = null;
        try {
            is.skip(4L);
            is.read(temp);
            data = new byte[Designer.toInt(temp, 0, 4)];
            is.read(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static String toString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] == -128) {
                buf.append('\n');
                continue;
            }
            if (b[i] == -127) {
                buf.append(' ');
                continue;
            }
            buf.append(charIndex.charAt(b[i] + 126));
        }
        return buf.toString();
    }

    public static void toBytesIndex(String str, byte[] b) {
        int length = Math.min(str.length(), b.length);
        System.arraycopy(Designer.toByteIndex(str, length), 0, b, 0, length);
    }

    public static byte[] toByteIndex(Object str) {
        String stri = String.valueOf(str);
        return Designer.toByteIndex(stri, stri.length());
    }

    public static byte[] toByteIndex(Object str, int length) {
        return Designer.toByteIndex(String.valueOf(str), length);
    }

    public static byte[] toByteIndex(String str, int length) {
        byte[] b = new byte[length];
        block4: for (int i = 0; i < length; ++i) {
            switch (str.charAt(i)) {
                case '\n': {
                    b[i] = -128;
                    continue block4;
                }
                case ' ': {
                    b[i] = -127;
                    continue block4;
                }
                default: {
                    b[i] = (byte)(charIndex.indexOf(str.charAt(i)) - 126);
                }
            }
        }
        return b;
    }

    public static int getCharWidth(byte b) {
        if (b == -127) {
            return space;
        }
        if (b == -128) {
            return 0;
        }
        return textCharWidth[b + 126];
    }

    public static int getStringWidth(byte[] b, int offset, int length) {
        int width = 0;
        int l = Math.min(offset + length, b.length);
        for (int i = offset; i < l; ++i) {
            width += Designer.getCharWidth(b[i]);
        }
        return width;
    }

    public static int getStringWidth(byte[] b) {
        return Designer.getStringWidth(b, 0, b.length);
    }

    public static int renderTextChar(Graphics g, int index, int colorType, int x, int y) {
        if (dat_textFont == null) {
            InputStream is = (class$java$io$InputStream == null ? (class$java$io$InputStream = Designer.class$("java.io.InputStream")) : class$java$io$InputStream).getResourceAsStream("/textFont.cmg");
            pal_textFont = Designer.readPal(is);
            dat_textFont = Designer.readData(is);
        }
        int shift = index * 120;
        int shift_color = colorType * 3;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 8; ++j) {
                int temp = i * 8 + j;
                Designer.rgb[temp] = pal_textFont[dat_textFont[temp + shift] + shift_color];
            }
        }
        g.drawRGB(rgb, 0, 8, x, y, 8, 15, true);
        return textCharWidth[index];
    }

    public static int drawChar(Graphics g, byte b, int colorType, int x, int y) {
        if (b == -127) {
            return space;
        }
        return Designer.renderTextChar(g, b + 126, colorType, x, y);
    }

    public static int drawString(Graphics g, byte[] b, int offset, int length, int colorType, int x, int y) {
        int width = 0;
        int memo = x;
        int l = offset + Math.min(b.length - offset, length);
        for (int i = offset; i < l; ++i) {
            if (b[i] == -128) {
                x = memo;
                y += charTotalHeight;
                continue;
            }
            int temp = Designer.drawChar(g, b[i], colorType, x, y);
            width += temp;
            x += temp;
        }
        return width;
    }

    public static int drawString(Graphics g, byte[] b, int offset, int length, byte margin, boolean isWordSplit, boolean ignoreExcessSpace, int colorType, int x, int y, int width, int height) {
        int end = y + height - charTotalHeight;
        int index = offset;
        int startIndex = offset;
        int endIndex = offset;
        int lineWidth = 0;
        int charCount = 0;
        int wordWidth = 0;
        length = Math.min(b.length, offset + length);
        while (y <= end && index < length) {
            lineWidth = 0;
            startIndex = !isWordSplit ? -1 : index;
            while (index < length) {
                if (b[index] == -128) {
                    ++index;
                    break;
                }
                if (b[index] == -127) {
                    if (lineWidth + space > width) break;
                    lineWidth += space;
                    ++index;
                    continue;
                }
                if (!isWordSplit) {
                    if (startIndex == -1) {
                        startIndex = index;
                    }
                    charCount = 0;
                    wordWidth = 0;
                    while (index < length && b[index] != -127 && b[index] != -128) {
                        wordWidth += Designer.getCharWidth(b[index]);
                        ++charCount;
                        ++index;
                    }
                    if (lineWidth + wordWidth <= width) {
                        lineWidth += wordWidth;
                        continue;
                    }
                    index -= charCount;
                    break;
                }
                if (lineWidth + Designer.getCharWidth(b[index]) > width) break;
                lineWidth += Designer.getCharWidth(b[index]);
                ++index;
            }
            if (lineWidth != 0) {
                if (startIndex == -1) {
                    startIndex = endIndex;
                }
                if (ignoreExcessSpace) {
                    for (endIndex = index - 1; endIndex > startIndex && b[endIndex] == -127; --endIndex) {
                    }
                }
                if (margin == 0) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, colorType, x, y);
                } else if (margin == 1) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, colorType, x + (width - lineWidth) / 2, y);
                } else if (margin == 2) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, colorType, x + width - lineWidth, y);
                }
            }
            y += charTotalHeight;
        }
        return index - offset;
    }

    public static int drawString(Graphics g, byte[] b, int offset, int length, int start, int end, byte margin, boolean isWordSplit, boolean ignoreExcessSpace, int colorType, int x, int y, int width, int height) {
        if (start < offset || start >= offset + length) {
            return 0;
        }
        int endY = y + height - charTotalHeight;
        int index = offset;
        int startIndex = offset;
        int endIndex = offset;
        int lineWidth = 0;
        int charCount = 0;
        int wordWidth = 0;
        length = Math.min(b.length, offset + length);
        end = Math.min(end, offset + length - 1);
        while (y <= endY && index < length) {
            lineWidth = 0;
            startIndex = !isWordSplit ? -1 : index;
            while (index < length) {
                if (b[index] == -128) {
                    ++index;
                    break;
                }
                if (b[index] == -127) {
                    if (lineWidth + space > width) break;
                    lineWidth += space;
                    ++index;
                    continue;
                }
                if (!isWordSplit) {
                    if (startIndex == -1) {
                        startIndex = index;
                    }
                    charCount = 0;
                    wordWidth = 0;
                    while (index < length && b[index] != -127 && b[index] != -128) {
                        wordWidth += Designer.getCharWidth(b[index]);
                        ++charCount;
                        ++index;
                    }
                    if (lineWidth + wordWidth <= width) {
                        lineWidth += wordWidth;
                        continue;
                    }
                    index -= charCount;
                    break;
                }
                if (lineWidth + Designer.getCharWidth(b[index]) > width) break;
                lineWidth += Designer.getCharWidth(b[index]);
                ++index;
            }
            if (lineWidth != 0) {
                if (startIndex == -1) {
                    startIndex = endIndex;
                }
                if (startIndex > end) break;
                if (ignoreExcessSpace) {
                    for (endIndex = index - 1; endIndex > startIndex && b[endIndex] == -127; --endIndex) {
                    }
                }
                if (endIndex > end) {
                    endIndex = end;
                }
                if (start > startIndex && start <= endIndex) {
                    if (margin == 0) {
                        Designer.drawString(g, b, start, endIndex - start + 1, colorType, x + Designer.getStringWidth(b, startIndex, start - startIndex), y);
                    } else if (margin == 1) {
                        Designer.drawString(g, b, start, endIndex - start + 1, colorType, x + (width - lineWidth) / 2 + Designer.getStringWidth(b, startIndex, start - startIndex), y);
                    } else if (margin == 2) {
                        Designer.drawString(g, b, start, endIndex - start + 1, colorType, x + width - lineWidth + Designer.getStringWidth(b, startIndex, start - startIndex), y);
                    }
                } else if (margin == 0) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, colorType, x, y);
                } else if (margin == 1) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, colorType, x + (width - lineWidth) / 2, y);
                } else if (margin == 2) {
                    Designer.drawString(g, b, startIndex, endIndex - startIndex + 1, colorType, x + width - lineWidth, y);
                }
                if (endIndex == end) break;
            }
            y += charTotalHeight;
        }
        return index - offset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        textCharWidth = new byte[]{6, 6, 5, 6, 6, 7, 6, 6, 6, 6, 6, 7, 6, 6, 6, 7, 6, 6, 6, 5, 5, 6, 5, 7, 7, 7, 6, 7, 6, 6, 7, 7, 7, 7, 7, 7, 6, 7, 7, 6, 7, 7, 6, 6, 6, 5, 5, 6, 3, 7, 6, 7, 6, 6, 6, 6, 6, 7, 6, 7, 6, 6, 6, 3, 5, 7, 7, 8, 8, 3, 5, 5, 7, 7, 4, 6, 3, 3, 4, 6, 6, 6, 7, 8, 4, 6, 4, 5, 7, 4, 5, 3, 5, 8, 4, 4, 5, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 5, 5, 5, 6, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8};
        space = (byte)4;
        charTotalHeight = (byte)15;
        rgb = new int[2000];
    }
}

